package com.jcg.java9.immutablecollections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Test {

	/* Require Java 9 To Execute This Code. Please Download From Following Link - http://jdk.java.net/9/ */

	public static void main(String[] args) {

		// List Implementation
		System.out.println("--- List Implementation ---");
		List<String> immutableList = List.of();
		System.out.println(immutableList);

		immutableList = List.of("one", "two", "three" /* , null */);
		System.out.println(immutableList);

		// immutableList.add("four");

		List<String> mutableList = new ArrayList<String>(List.of("one", "two", "three"));
		mutableList.add("four");
		mutableList.add(null);
		System.out.println(mutableList);

		// Set Implementation
		System.out.println("--- Set Implementation ---");
		Set<String> immutableSet = Set.of();
		System.out.println(immutableSet);

		immutableSet = Set.of("one", "two", "three" /* , null */);
		System.out.println(immutableSet);

		// immutableSet.add("four");

		Set<String> mutableSet = new HashSet<String>(Set.of("one", "two", "three"));
		mutableSet.add("four");
		mutableSet.add(null);
		System.out.println(mutableSet);

		// Map Implementation
		System.out.println("--- Map Implementation ---");
		Map<Integer, String> immutableMap = Map.of();
		System.out.println(immutableMap);

		immutableMap = Map.of(1, "one", 2, "two", 3, "three" /* , 4, null */);
		System.out.println(immutableMap);

		// immutableMap.put(4, "four");

		Map<Integer, String> mutableMap = new HashMap<Integer, String>(Map.of(1, "one", 2, "two", 3, "three"));
		System.out.println(mutableMap);

		mutableMap.put(4, "four");
		mutableMap.put(5, null);
		System.out.println(mutableMap);

		// Map With Entry Implementation
		System.out.println("--- Map With Entry Implementation ---");
		Map<Integer, String> newImmutableMap = Map.ofEntries();
		System.out.println(newImmutableMap);

		newImmutableMap = Map.ofEntries(Map.entry(1, "one"), Map.entry(2, "two"), Map.entry(3, "three"));
		System.out.println(newImmutableMap);
	}
}